<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Cart;
use App\Models\ProductVariant;
use App\Models\CartItem;
use Illuminate\Support\Facades\Auth;
use App\Models\Coupon;

class CartController extends Controller
{
    // public function addToCart(Request $request)
    // {
    //     $userId = auth()->id();

    //     $request->validate([
    //         'product_id' => 'required|exists:products,id',
    //         'variant_id' => 'required|exists:product_variants,id',
    //         'quantity'   => 'required|integer|min:1',
    //     ]);

    //     $variant = ProductVariant::where('id', $request->variant_id)
    //         ->where('product_id', $request->product_id)
    //         ->with('stocks') // ✅ load all stocks
    //         ->firstOrFail();

    //     // ✅ Calculate usable stock across locations
    //     $availableQty = $variant->stocks
    //         ->where('is_available', 1)
    //         ->sum(function ($stock) {
    //             return max(
    //                 ($stock->available_qty ?? 0) - ($stock->reserved_qty ?? 0),
    //                 0
    //             );
    //         });

    //     if ($availableQty <= 0) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Product out of stock'
    //         ], 400);
    //     }

    //     if ($request->quantity > $availableQty) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Quantity exceeds available stock'
    //         ], 400);
    //     }

    //     $cart = Cart::firstOrCreate([
    //         'user_id' => $userId
    //     ]);

    //     $cartItem = CartItem::where([
    //         'cart_id'    => $cart->id,
    //         'variant_id' => $variant->id
    //     ])->first();

    //     if ($cartItem) {
    //         $cartItem->quantity += $request->quantity;
    //     } else {
    //         $cartItem = new CartItem();
    //         $cartItem->cart_id    = $cart->id;
    //         $cartItem->product_id = $request->product_id;
    //         $cartItem->variant_id = $variant->id;
    //         $cartItem->price      = $variant->offer_price;
    //         $cartItem->quantity   = $request->quantity;
    //     }

    //     // ✅ Re-check after increment
    //     if ($cartItem->quantity > $availableQty) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Quantity exceeds available stock'
    //         ], 400);
    //     }

    //     $cartItem->subtotal = $cartItem->price * $cartItem->quantity;
    //     $cartItem->save();

    //     return response()->json([
    //         'success'     => true,
    //         'message'     => 'Product added to cart',
    //         'cart_count'  => $cart->items()->sum('quantity')
    //     ]);
    // }

    // public function updateQuantity(Request $request)
    // {
    //     $request->validate([
    //         'cart_item_id' => 'required|exists:cart_items,id',
    //         'quantity'     => 'required|integer|min:1'
    //     ]);

    //     $cartItem = CartItem::where('id', $request->cart_item_id)
    //         ->whereHas(
    //             'cart',
    //             fn($q) =>
    //             $q->where('user_id', auth()->id())
    //         )
    //         ->with('variant.stocks')
    //         ->firstOrFail();

    //     $variant = $cartItem->variant;

    //     // ✅ Sum usable stock across all locations
    //     $availableQty = $variant->stocks
    //         ->where('is_available', 1)
    //         ->sum(function ($stock) {
    //             return max(
    //                 ($stock->available_qty ?? 0) - ($stock->reserved_qty ?? 0),
    //                 0
    //             );
    //         });

    //     if ($availableQty <= 0) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Product out of stock'
    //         ], 400);
    //     }

    //     if ($request->quantity > $availableQty) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Quantity exceeds available stock'
    //         ], 400);
    //     }

    //     $cartItem->quantity = $request->quantity;
    //     $cartItem->save();

    //     return response()->json([
    //         'success'  => true,
    //         'message'  => 'Quantity updated',
    //         'subtotal' => (float) $cartItem->subtotal
    //     ]);
    // }

    public function addToCart(Request $request)
    {
        $userId = auth()->id();

        $request->validate([
            'product_id' => 'required|exists:products,id',
            'variant_id' => 'required|exists:product_variants,id',
            'quantity'   => 'required|integer|min:1',
            'meters'     => 'nullable|numeric|min:0.1',
            'unit_price' => 'nullable|numeric|min:0',
            'total_price' => 'nullable|numeric|min:0',
            'is_sample'  => 'nullable|boolean'
        ]);

        $variant = ProductVariant::with('product')
            ->where('id', $request->variant_id)
            ->where('product_id', $request->product_id)
            ->firstOrFail();

        $product = $variant->product;


        $cart = Cart::firstOrCreate([
            'user_id' => $userId
        ]);
        $isSample = $request->is_sample ?? 0;

        $cartItem = CartItem::where([
            'cart_id'    => $cart->id,
            'variant_id' => $variant->id,
            'is_sample'  => $isSample
        ])->first();


        if ($isSample && $product->sample_purchase) {
            $price = $product->sample_purchase_rate;
        } else {
            $price = $variant->offer_price;
        }
        $isFabric = strtolower($product->category?->slug ?? '') == 'fabric';
        if ($cartItem) {
            $cartItem->quantity += $request->quantity;
        } else {
            $cartItem = new CartItem();
            $cartItem->cart_id    = $cart->id;
            $cartItem->product_id = $request->product_id;
            $cartItem->variant_id = $variant->id;
            $cartItem->price = $price;
            $cartItem->quantity   = $request->quantity;
            $cartItem->meters   = $request->meters;
            $cartItem->unit_price   = $request->unit_price;
            $cartItem->total_price   = $request->total_price;
            $cartItem->is_sample = $isSample; // optional column if you add
        }
        if ($isFabric) {
            $cartItem->subtotal = $request->total_price;
        } else {
      echo   $cartItem->subtotal = $cartItem->price * $cartItem->quantity;die();
        }

       
        $cartItem->save();

        return response()->json([
            'success'    => true,
            'message'    => 'Product added to cart',
            'cart_count' => $cart->items()->sum('quantity')
        ]);
    }
    // public function addToCart(Request $request)
    // {
    //     $userId = auth()->id();

    //     $request->validate([
    //         'product_id' => 'required|exists:products,id',
    //         'variant_id' => 'required|exists:product_variants,id',
    //         'quantity'   => 'required|integer|min:1',
    //         'meters'     => 'nullable|numeric|min:0.1',
    //         'unit_price' => 'nullable|numeric|min:0',
    //         'total_price' => 'nullable|numeric|min:0',
    //         'is_sample'  => 'nullable|boolean'
    //     ]);

    //     $variant = ProductVariant::with('product')
    //         ->where('id', $request->variant_id)
    //         ->where('product_id', $request->product_id)
    //         ->firstOrFail();

    //     $product = $variant->product;

    //     $isFabric = strtolower($product->category?->slug ?? '') == 'fabric';

    //     $cart = Cart::firstOrCreate([
    //         'user_id' => $userId
    //     ]);

    //     $isSample = $request->is_sample ?? 0;

    //     $cartItem = CartItem::where([
    //         'cart_id'    => $cart->id,
    //         'variant_id' => $variant->id,
    //         'is_sample'  => $isSample
    //     ])->first();

    //     if ($cartItem) {

    //         if ($isFabric) {
    //             $cartItem->meters += $request->meters;
    //         } else {
    //             $cartItem->quantity += $request->quantity;
    //         }

    //         $cartItem->subtotal += $request->total_price;
    //     } else {

    //        $cartItem = new CartItem();
    //         $cartItem->cart_id    = $cart->id;
    //         $cartItem->product_id = $request->product_id;
    //         $cartItem->variant_id = $variant->id;
    //         $cartItem->price = $price;
    //         $cartItem->quantity   = $request->quantity;
    //         $cartItem->is_sample = $isSample; // optional column if you add

    //         if ($isFabric) {
    //             $cartItem->meters   = $request->meters;
    //             $cartItem->unit_price   = $request->unit_price;
    //             $cartItem->total_price   = $request->total_price;
    //             $cartItem->quantity = 1;
    //         } else {
    //             $cartItem->quantity = $request->quantity;
    //         }
    //     }

    //     $cartItem->save();

    //     return response()->json([
    //         'success'    => true,
    //         'message'    => 'Product added to cart',
    //         'cart_count' => $cart->items()->sum('quantity')
    //     ]);
    // }
    public function updateQuantity(Request $request)
    {
        $request->validate([
            'cart_item_id' => 'required|exists:cart_items,id',
            'quantity'     => 'required|integer|min:1',
            'total_price'  => 'required|numeric|min:0'
        ]);

        $cartItem = CartItem::where('id', $request->cart_item_id)
            ->whereHas('cart', function ($q) {
                $q->where('user_id', auth()->id());
            })
            ->firstOrFail();

        $cartItem->quantity = $request->quantity;
        $cartItem->subtotal = $request->total_price;
        $cartItem->save();

        return response()->json([
            'success'  => true,
            'message'  => 'Quantity updated',
            'subtotal' => (float) $cartItem->subtotal
        ]);
    }


    public function index()
    {
        $cart = Cart::with([
            'items.product.category:id,slug',
            'items.product:id,name,category_id',
            'items.variant.primaryImage',
            'coupon:id,code,type,value'
        ])->where('user_id', auth()->id())->first();

        if (!$cart || $cart->items->isEmpty()) {
            return response()->json([
                'success' => true,
                'data' => [
                    'items' => [],
                    'coupon' => null,
                    'price_details' => [
                        'sub_total' => 0,
                        'delivery_fee' => 0,
                        'discount' => 0,
                        'total' => 0
                    ]
                ]
            ]);
        }

        $items = $cart->items->map(function ($item) {

            $image = $item->variant->primaryImage->image_path ?? null;

            $isFabric = strtolower($item->product->category?->slug ?? '') == 'fabric';

            $data = [
                'cart_item_id' => $item->id,
                'product_id'   => $item->product_id,
                'name'         => $item->product->name,

                'variant' => [
                    'variant_id' => $item->variant_id,
                    'color'      => $item->variant->color_name ?? null,
                    'image'      => $image ? asset($image) : null
                ],

                'quantity' => $item->quantity,
                'subtotal' => (float) $item->subtotal,
            ];

            // ✅ ADD FABRIC DATA ONLY IF FABRIC
            if ($isFabric) {
                $data['fabric_meters']      = (float) $item->meters;
                $data['fabric_unit_price']  = (float) $item->unit_price;
                $data['fabric_total_price'] = (float) $item->total_price;
            }

            return $data;
        });

        $subTotal = $cart->items->sum(function ($item) {

            $isFabric = strtolower($item->product->category?->slug ?? '') == 'fabric';

            return $isFabric
                ? (float) $item->total_price
                : (float) $item->subtotal;
        });

        $deliveryFee = 0;
        $discount    = $cart->discount ?? 0;

        $total = max(0, $subTotal + $deliveryFee - $discount);


        return response()->json([
            'success' => true,
            'data' => [
                'items' => $items,

                'coupon' => $cart->coupon ? [
                    'coupon_id' => $cart->coupon->id,
                    'code'      => $cart->coupon->code,
                    'type'      => $cart->coupon->type,
                    'value'     => (float) $cart->coupon->value
                ] : null,

                'price_details' => [
                    'sub_total'    => (float) $subTotal,
                    'delivery_fee' => (float) $deliveryFee,
                    'discount'     => (float) $discount,
                    'total'        => (float) $total
                ]
            ]
        ]);
    }




    public function remove($cartItemId)
    {
        $cartItem = CartItem::where('id', $cartItemId)
            ->whereHas(
                'cart',
                fn($q) =>
                $q->where('user_id', auth()->id())
            )->firstOrFail();

        $cartItem->delete();

        return response()->json([
            'success' => true,
            'message' => 'Item removed from cart'
        ]);
    }

    public function applyCoupon(Request $request)
    {
        $request->validate([
            'coupon_code' => 'required|string'
        ]);

        $user = auth()->user();

        $cart = Cart::with(['items.product', 'coupon'])
            ->where('user_id', $user->id)
            ->first();


        if (!$cart || $cart->items->isEmpty()) {
            return response()->json([
                'success' => false,
                'message' => 'Cart is empty'
            ], 400);
        }

        $coupon = Coupon::where('code', $request->coupon_code)
            ->where('is_active', 1)
            ->whereDate('start_date', '<=', now())
            ->where(function ($q) {
                $q->whereNull('end_date')
                    ->orWhereDate('end_date', '>=', now());
            })
            ->first();

        if (!$coupon) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid or expired coupon'
            ], 404);
        }

        // Cart subtotal
        $cartSubtotal = $cart->items->sum(fn($item) => $item->price * $item->quantity);

        // Min purchase check
        if ($coupon->min_purchase && $cartSubtotal < $coupon->min_purchase) {
            return response()->json([
                'success' => false,
                'message' => 'Minimum purchase ₹' . $coupon->min_purchase . ' required'
            ], 422);
        }

        // First-time user
        if ($coupon->first_time_user_only && $user->orders()->exists()) {
            return response()->json([
                'success' => false,
                'message' => 'Coupon only for first-time users'
            ], 422);
        }

        // 🔥 Calculate Discount
        if ($coupon->type === 'percentage') {
            $discount = ($cartSubtotal * $coupon->value) / 100;

            if ($coupon->max_discount_amount) {
                $discount = min($discount, $coupon->max_discount_amount);
            }
        } else {
            $discount = $coupon->value;
        }

        // Prevent over-discount
        $discount = min($discount, $cartSubtotal);

        // Final total
        $finalTotal = $cartSubtotal - $discount;

        // Save coupon to cart
        // overwrite existing coupon automatically (change coupon)
        $cart->coupon_id = $coupon->id;
        $cart->discount  = $discount;
        $cart->total     = $finalTotal;
        $cart->save();

        return response()->json([
            'success' => true,
            'message' => 'Coupon applied successfully',
            'data' => [
                'coupon' => [
                    'code' => $coupon->code,
                    'type' => $coupon->type,
                    'value' => $coupon->value,
                ],
                'price_details' => [
                    'sub_total' => $cartSubtotal,
                    'discount'  => round($discount, 2),
                    'total'     => round($finalTotal, 2),
                ]
            ]
        ]);
    }

    public function removeCoupon()
    {
        $cart = Cart::where('user_id', auth()->id())->firstOrFail();

        $cart->update([
            'coupon_id' => null,
            'discount' => 0,
            'total' => 0
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Coupon removed'
        ]);
    }
}
